;ADAMED
;40 column text editor
;By Walid Maalouli
;Last update 8/18/19

bdos	equ	5			;entry point for BDOS
consts	equ 0bh			;console status function
conio	equ	6			;direct console I/O function
cursr1	equ	5fh			;normal cursor character 
cursr2	equ	0bfh		;inverse cursor character
lstout	equ	5			;list output function
writef	equ	15h			;write a sequential file record
readf	equ	14h			;read a sequential file record
delf	equ	13h			;delete file
closef	equ	10h			;close file
openf	equ	0fh			;open file
makef	equ	16h			;make new file
curdsk	equ	19h			;get current disk
dma		equ	80h			;dma buffer
filcb	equ	5ch			;file control block

		org	100h
		
;Look for configuration file	
     	lxi		h,tabasm	;set default tab
		shld	tabpos
		mvi		h,11	;place config file name in fcb
		lxi		b,svflnm
		lxi		d,filcb+1
nxtlet	ldax	b
		stax	d
		inx		b
		inx		d
		dcr		h
		jnz		nxtlet
		mvi		c,openf	;look for configuration file
		lxi		d,filcb
		call	bdos
		cpi		0ffh	;config file present?
		jz		defset	;load default if it is not
		mvi		c,readf	;read data
		lxi		d,filcb
		call	bdos
		mvi		c,closef	;close configuration file
		call	bdos
		lda		dma+2	;get tab setting
		cpi		1
		jnz		getcol
		lxi		h,tabpas
		shld	tabpos
getcol	lda		dma+1	;get background color
		mov		b,a
		lda		dma		;get foreground color
		rlc
		rlc
		rlc
		rlc
		ora		b
		jmp		setcol
		
;set up 40-col text mode		
defset	mvi		a,21h	;medium green on black in VR7
setcol	out		0bfh
		mvi		a,87h
		out 	0bfh
		mvi 	a,2		;screen image table at 0800h
		out 	0bfh
		mvi 	a,82h
		out 	0bfh
		mvi		a,0		;pattern descriptor table at 0000h
		out 	0bfh
		mvi		a,84h
		out 	0bfh
		mvi 	a,0f0h	;start text mode
		out 	0bfh
		mvi		a,81h
		out 	0bfh

;create inverse character set
		call	revchr

;title screen display
		call 	clrscr		;clear the screen
		lxi		b,837h		;screen position in VRAM
		lxi		h,8			;number of bytes to write
		lxi		d,title1	;point to address of text
		call	VMBW
		lxi		b,87eh
		lxi		h,1ah
		lxi		d,title2
		call	VMBW
		lxi		b,923h
		lxi		h,11h
		lxi		d,credit
		call	VMBW
		lxi		b,977h
		lxi		h,9
		lxi		d,date
		call	VMBW
		
		call	keyprs	;wait for a key
		call 	clrscr	;clear the screen
	
;initialize editor
		call	clrbuf	;clear text buffer
		mvi		b,14	;clear filename space
		lxi		d,filnam
		mvi		a,80h
conclr	stax	d
		inx		d
		dcr		b
		jnz		conclr
		mvi		b,15	;clear search string space
		lxi		d,srhstr
		mvi		a,80h
clrstr	stax	d
		inx		d
		dcr		b
		jnz		clrstr
		
;main editing loop
txted	call	clccur	;update screen address of cursor
		mvi		a,cursr1
		sta		curchr
		call	discur	;display cursor
		lda		hlpflg	;check if help status line on
		cpi		0
		jnz		hlpdis
		lhld	linloc	;update line number if it is off
		call	updlin
		call	displn
hlpdis	mvi		c,conio	;look for keypress
		mvi		e,0ffh	;configure function for input
		call	bdos	
		ora		a		;is key pressed?
		jnz		cont	;check key value if it is
		jmp		txted	;check again if not
cont	cpi		0dh		;carriage return?
		jnz		notcr
		call 	bufchk	;check if at end of buffer
		cpi		1		;check if accumulator is set
		jnz		cont7	;not at end of buffer
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		call	beep
		jmp		txted
cont7	call	chkeof	;check if at eof
		cpi		1
		jnz		cont10	;keep going if not
		lhld	eofptr	;get eof pointer
		lxi		d,42	;offset to next line
		dad		d		;update eof pointer
		shld	eofptr
cont10	call	wrtlin	;save line to text buffer
		lda		cury	;get cursor y
		cpi		23		;at bottom of screen?
		jnz		cont4	;increase cursor y by 1 if not
		call	scrup	;scroll screen up
		jmp		inslin
cont4	inr		a		;update cursor y
		sta		cury	
		jmp		inslin
notcr	cpi		9		;tab key?
		jnz		nottab
		lda		curx	;get cursor x position
		mov		b,a		;store cursor x in B register
		lhld	tabpos	;point to tab positions address
		xchg
		ldax	d		;get tab position
nxttab	cmp		b		;cursor x less than tab position?
		jz		advtab
		jp		settab	;if yes then move cursor to next tab
advtab	inx		d		;next tab position
		ldax	d
		cpi		0		;are we at last tab position?
		jz		txted	;if yes then do nothing
		jmp		nxttab
settab	sta		curx	;update cursor x position
		jmp		txted
nottab	cpi		8		;backspace?
		jnz		notbak
		lda		curx	;get cursor x position
		cpi		0		;check if at beginning of line
		jz		txted	;do nothing if it is
		sui		1		;move cursor 1 character left
		sta		curx	;update cursor x position
		call	clccur	;update cursor screen position
		mvi		d,20h	;place space character at cursor position
		call	VSBW
		jmp		txted	
notbak	cpi		19		;left arrow?
		jnz		notlft
		lda		curx	;get cursor x position
		cpi		0		;at beginning of line?
		jz		txted	;ignore if yes
		dcr		a		;move cursor left one position
		sta		curx	
		jmp		txted
notlft	cpi		4		;right arrow?
		jnz		notrt
		lda		curx
		cpi		27h		;at end of line?
		jz		txted	;ignore if yes
		inr		a		;move cursor right one position
		sta		curx
		jmp		txted
notrt	cpi		5		;up arrow?
		jnz		notup
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lda		tmpchr	;restore cursor x position
		sta		curx
		call	bufst	;check if at start of buffer
		cpi		1		;is the accumulator set?
		jnz		curtop
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		call	beep
		jmp		txted	;ignore action if it is
curtop	lda		cury	;get cursor y position
		cpi		1		;at top of screen?
		jnz		nottop	;ignore if not
		lhld	linloc	;check if previous 5 lines within start of buffer
		lxi		d,-210
		dad		d
		xchg
		lhld	txtbuf
		mov		a,h
		cmp		d
		jc		okscrl
		jz		chklbt
noscrl	xchg			;if not then display from top of buffer
		call	refrsh
		lhld	txtbuf	
		shld	linloc
		mvi		a,1
		sta		cury
		jmp		txted
chklbt	mov		a,l
		cmp		e
		jc		okscrl
		jz		okscrl
		jmp		noscrl
okscrl	call	scrdn	;scroll down
		jmp		txted
nottop	dcr		a		;move cursor up one line
		sta		cury
		lhld	linloc	;get current line address in buffer
		lxi		d,-42	;offset to previous line
		dad		d		;update current line address
		shld	linloc
		jmp		txted
notup	cpi		24		;down arrow?
		jnz		notdwn
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lda		tmpchr	;restore cursor x position
		sta		curx
		call	chkeof	;check if at eof
		cpi		1
		jnz		cont9	;keep going if not
		call	beep
		jmp		txted	;otherwise ignore
cont9	lda		cury	;load cursor y
		cpi		23		;at bottom of edit screen?
		jnz		notbot	;continue if not
		lhld	linloc	;get current line address
		lxi		d,42	;offset to next line
		dad		d		;point to next line
		shld	linloc
		call	scrup	;scroll screen up 
		jmp		txted
notbot	inr		a		;move cursor down one line
		sta		cury
		lhld	linloc	;point to next line in buffer
		lxi		d,42	;offset to next line
		dad		d
		shld	linloc
		jmp		txted
notdwn	cpi		151		;delete?
		jnz		notdel
		lhld	curpos	;get cursor screen address
		mvi		d,20h	;space character in d
		call	VSBW	;erase character under cursor
		lda		curx	;get cursor x position
		cpi		27h		;at end of line?
		jz		txted	;if yes then done
		inx		h		;point to character right of cursor
		push	h		;transfer screen address to BC
		pop		b
		inr		a		;calculate number of characters right of cursor
		mov		l,a		
		mvi		a,28h
		sub		l
		mov		l,a
		mvi		h,0		;HL now has number of bytes to read
		push	h		;save that number
		lxi		d,linbuf	;point to line buffer in memory
		call	VMBR	;read rest of line into buffer
		lhld	curpos	;get cursor screen address
		push	h		;transfer to BC
		pop		b	
		pop 	h		;retrieve number of bytes to read
		lxi		d,linbuf	;point to line buffer in memory
		call	VMBW	;write line back shifted 1 to left
		mvi		a,20h	;clear right-most character on line
		out		0beh	
		jmp		txted
notdel	cpi		148		;insert?
		jnz		notins
		lda		curx	;get cursor x position
		cpi		27h		;at end of line?
		jz		txted	;ignore if yes
		lhld	curpos	;get cursor screen address
		push	h		;transfer to BC
		pop		b
		inr		a		;calculate number of characters 
		mov		l,a		
		mvi		a,28h
		sub		l
		mov		l,a
		mvi		h,0		;HL now has number of bytes to read
		push	h		;save that number
		lxi		d,linbuf	;point to line buffer in memory
		call	VMBR	;read line from cursor to end - 1
		in		0beh	;read last character on line
		cpi		20h		;is it a space?
		jz		cont1	;no action if it is
		call	beep	;otherwise send audible warning
cont1	lhld	curpos	;blank character under cursor
		mvi		d,20h	
		call	VSBW
		inx		h		;point to next cursor position
		push	h		;transfer address to BC
		pop		b
		pop		h		;retrieve number of bytes to write
		lxi		d,linbuf	;point to line buffer in memory
		call	VMBW	;write line back shifted 1 to right
		jmp		txted
notins	cpi		150		;clear?
		jnz		notclr
		mvi		a,0		;move cursor to beginning of line
		sta		curx	;update cursor x variable
		call 	clccur	;update cursor screen position
		mvi		d,20h	;space character
		call	VSBW	;write space at cursor
		mvi		b,28h	;remaining characters counter
cont2	mvi 	a,20h
		dcr		b		;fill rest of line with spaces
		jz		txted
		out		0beh	
		jmp		cont2
notclr	cpi		128		;home?
		jnz		nothom
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lda		cury	;get cursor y
		cpi		1		;already at top of screen?
		jz		adjx	;just home cursor x if yes
		lhld	linloc	;get current line address in buffer
		lxi		b,-42	;offset to previous line
cont8	dad		b		;adjust current line address
		dcr		a		;move back one line
		cpi		1		;are we at top of screen?
		jnz		cont8	;keep moving back if not
		shld	linloc	;update current line pointer
		sta		cury	;update cursor y
adjx	mvi		a,0		;cursor x to beginning of line
		sta		curx
		jmp		txted
nothom	cpi		27		;escape?
		jnz		notesc
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lxi		d,extprt	;verify quit
		call	prterr
		lda		tmpchr
		cpi		59h	;Y?
		jz		versav
		cpi		79h	;y?
		jz		versav
		jmp		txted
versav	lxi		d,savprt	;verify save
		call	prterr
		lda		tmpchr
		cpi		59h	;Y?
		jz		setflg
		cpi		79h	;y?
		jz		setflg
		jmp		exit
setflg	mvi		a,1
		sta		savflg
		jmp		qsave
notesc	cpi		129		;I key?
		jnz		notI
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
tof		lhld	txtbuf	;get address of start of buffer
		shld	linloc	;save in current line pointer
		xchg			;move to DE
		call	refrsh	;update the screen
		mvi		a,0		;move cursor to first line
		sta		curx
		mvi		a,1
		sta		cury
		jmp		txted
notI	cpi		130		;II key?
		jnz		notII
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lhld	txtbuf	;check if eof pointer within first page
		lxi		d,924
		dad		d		;HL now has address of last line on page
		xchg
		lhld	eofptr
		mov		a,h		
		cmp		d
		jc		fstpag
		jz		chklsb
		jmp		notfst
chklsb	mov		a,l
		cmp		e
		jc		fstpag
		jz		fstpag
notfst	lxi		d,-924	;offset to buffer line at top of page
		dad		d		;add to eof pointer address
		xchg			;move to DE
		call	refrsh	;refresh the screen
		lhld	eofptr	;make current line at eof pointer
		shld	linloc
		mvi		a,0		;move cursor to bottom line on page
		sta		curx
		mvi		a,23
		sta		cury
fstpag	jmp		txted	;Ignore if eof in first page	
notII	cpi		131		;III key?
		jnz		notIII	
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lhld	txtbuf	;check if current line in first page
		lxi		b,924
		dad		b
		xchg
		lhld	linloc
		mov		a,h
		cmp		d
		jc		tof		;if it is then display from top of buffer
		jz		chlsb
		jmp		cont11
chlsb	mov		a,l
		cmp		e
		jc		tof
		jz		tof
cont11	lxi		d,-966	;offset to previous page
		dad		d		;update current line pointer
		shld	linloc
		xchg			;move to DE
		call	refrsh	;refresh the screen
		mvi		a,0		;place cursor at top of page
		sta		curx
		mvi		a,1
		sta		cury
		jmp		txted
notIII	cpi		132		;IV key?
		jnz		notIV
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lhld	linloc	;get current line address in buffer
		lda		cury	;check if eof in same page
		mov		b,a
		mvi		a,23
		sub		b		;A now has number of lines to bottom of page
		cpi		0
		jz		cont12	;already at bottom of page
		mov		b,a
		lhld	linloc
		lxi		d,42
redo2	dad		d
		dcr		b
		jnz		redo2
cont12	xchg			;DE now has address of last line on page
		lhld	eofptr
		mov		a,h
		cmp		d
		jc		inpag	;eof in same page
		jz		cklsb
		jmp		outpag
cklsb	mov		a,l
		cmp		e
		jc		inpag
		jz		inpag
outpag	xchg			;address of last line on page
		lxi		d,42	;point to next line in buffer
		dad		d
		shld	linloc
		jmp		dispag
inpag	lhld	eofptr
		shld	linloc	;current line pointer = eof
dispag	xchg			;DE now has top of page line address
		call 	refrsh
		mvi		a,0
		sta		curx
		mvi		a,1
		sta		cury
		jmp		txted	
notIV	cpi		141		;shift-V key?
		jnz		notV
		lhld	eofptr	;check if file is empty
		xchg
		lhld	txtbuf
		mov		a,h
		cmp		d
		jnz		notbeg
		mov		a,l
		cmp		e
		jnz		notbeg
		lxi		d,blklin	;erase current line
		lhld	linloc
		push	h
		pop		b
		call	coplin
		lhld	linloc
		xchg
		call	refrsh
		jmp		txted	;ignore command if yes
notbeg	lhld	linloc	;save current line pointer
		shld	curlin
		xchg			;check if at eof already
		lhld	eofptr
		mov		a,h
		cmp		d
		jnz		loop3
		mov		a,l
		cmp		e
		jnz		loop3
		lxi		d,blklin	;erase current line
		lhld	curlin
		push	h
		pop		b
		call	coplin
		lhld	linloc	;decrease line pointer by 1
		lxi		d,-42
		dad		d
		shld	linloc
		lda		cury	;adjust cursor up 1 line
		dcr		a
		sta		cury
		jmp		deceof
loop3	lhld	curlin	;move 2nd line to 1st
		lxi		d,42
		dad		d
		xchg
		lhld	curlin
		push	h
		pop		b
		call	coplin
		lhld	curlin	;advance line pointer to next line
		lxi		d,42
		dad		d
		shld	curlin
		xchg			;check if line pointer at eof
		lhld	eofptr
		mov		a,h
		cmp		d
		jnz		loop3
		mov		a,l
		cmp		e
		jnz		loop3
deceof	lhld	eofptr	;decrease eof pointer by 1 line
		lxi		d,-42
		dad		d		
		shld	eofptr
		call	prtref	;refresh the screen
		jmp		txted
notV	cpi		134		;VI key?
		jnz		notVI
		mvi		a,0
		sta		hlpflg
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lhld	linloc	;display search prompt
		call 	updlin
		call	displn
		lhld	stspos
		inx		h
		push	h
		pop		b
		lxi		d,srhtxt
		lxi		h,11
		call	VMBW
		call	inpsrh	;input search string
		lda		tmpchr
		cpi		0
		jz		txted
		lhld	eofptr	;check if blank file
		xchg
		lhld	txtbuf
		mov		a,h
		cmp		d
		jnz		notblk
		mov		a,l
		cmp		e
		jnz		notblk
		jmp		txted
notblk	lhld	linloc	;check if at eof
		xchg			
		lhld	eofptr
		mov		a,h
		cmp		d
		jnz		cont64
		mov		a,l
		cmp		e
		jnz		cont64
		jmp		srheof
cont64	lhld	linloc
		lxi		d,42
		dad		d
		shld	srhptr
cont62	xchg
		lhld	linloc	;check if entire file searched
		mov		a,h
		cmp		d
		jnz		cont63
		mov		a,l
		cmp		e
		jnz		cont63
dnsrh	lxi		d,srhfl	;print error message if it is
		call	prterr
		jmp		txted
cont63	lhld	eofptr	;check if at eof
		mov		a,h
		cmp		d
		jnz		cont60
		mov		a,l
		cmp		e
		jnz		cont60
srheof	lhld	txtbuf	;point to start of file if it is
		shld	srhptr
		jmp		cont62
cont60	mvi		a,0		;initialize search cursors
		sta		fcurx
		sta		srhcur
		lxi		d,srhstr ;search current line for string
		lhld	srhptr
		push	h
		pop		b
cont61	ldax	b		;get character from current line
		adi		60h		;offset to inverse character set
		mov		h,a
		ldax	d
		cmp		h		;compare to search string character
		jnz		getnxt	
		inx		d
		inx		b
		lda		srhcur	;check if at end of search string
		inr		a
		sta		srhcur
		cpi		15		
		jz		fndstr	;if we are then match found
		ldax	d		;check if next char in search string is blank
		cpi		80h
		jz		fndstr	;if it is then match found
		lda		fcurx
		inr		a
		sta		fcurx
		cpi		40		;check if at end of line
		jnz		cont61	;check next character if it is not
nomat	lhld	srhptr	;move to next line in buffer
		lxi		d,42
		dad		d
		shld	srhptr
		jmp		cont62
getnxt	lda		fcurx	;check if at end of line
		inr		a
		cpi		40
		jz		nomat	;next line if it is
		sta		fcurx	;otherwise look at next character in line
		mvi		a,0
		sta		srhcur
		inx		b
		lxi		d,srhstr
		jmp		cont61
fndstr	lhld	srhptr	;move to line with matched string
		shld	linloc
		xchg
		call	refrsh
		mvi		a,1
		sta		cury
		lda		srhcur
		mov		b,a
		lda		fcurx
		inr		a
		sub		b
		sta		curx
		jmp		txted	
notVI	cpi		146		;copy?
		jnz		notcop
		lhld	linloc	;copy current line to copy buffer
		xchg
		lxi		b,copbuf
		call	coplin
		jmp		txted
notcop	cpi		154		;move? 
		jnz		notmov
		lhld	linloc	;copy line from copy buffer to current line
		push	h
		pop		b
		lxi		d,copbuf
		call	coplin
		mvi		a,0		;update line on screen
		sta		curx
		call	clccur
		push	h
		pop		b
		lxi		d,copbuf
		lxi		h,40
		call	VMBW
		jmp		txted
notmov	cpi		149		;print?
		jnz		notprt
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
		lhld	eofptr	;check if file is empty
		xchg
		lhld	txtbuf
		mov		a,h
		cmp		d
		jnz		notemp
		mov		a,l
		cmp		e
		jnz		notemp
		jmp		txted	;ignore command if yes
notemp	mvi		a,0dh	;send CR/LF to printer
		mov		e,a
		mvi		c,lstout
		call	bdos
		mvi		a,0ah
		mov		e,a
		mvi		c,lstout
		call	bdos
		lhld	txtbuf	;send file to printer line by line
		shld	curlin
		xchg
loop5	mvi		h,42
loop4	ldax	d
		push	d
		push	h
		mov		e,a
		mvi		c,lstout
		call	bdos
		pop		h
		pop		d
		inx		d
		xchg	
		shld	curlin
		xchg
		dcr		h
		jnz		loop4
		lhld	eofptr	;check if at eof
		push	h
		pop		b
		lhld	curlin
		mov		a,h
		cmp		b
		jnz		loop5	;if not then process another line
		mov		a,l
		cmp		c
		jnz		loop5
		jmp		txted	
notprt	cpi		152		;shift-wildcard?
		jnz		notwld
		lda		hlpflg
		cpi		0
		jnz		dspln
		lhld	stspos
		push	h
		pop		b
		lxi		d,ststxt
		lxi		h,40
		call	VMBW
		mvi		a,1
		sta		hlpflg
		jmp		txted	
dspln	lhld	stspos
		push	h
		pop		b
		lxi		d,blklin
		lxi		h,40
		call	VMBW
		mvi		a,0
		sta		hlpflg
		jmp		txted
notwld	cpi		147		;get key?
		jnz		notget
		mvi		a,0		;clear the status line help flag
		sta		hlpflg
		lhld	linloc	;display load file prompt
		call 	updlin
		call	displn
		lhld	stspos
		inx		h
		push	h
		pop		b
		lxi		d,ldtext
		lxi		h,10
		call	VMBW
		call	inpfil	;get filename input from user
		lda		tmpchr	;get flag
		cpi		0		
		jz		opcan	;cancel if flag is reset
		call	setfil	;transfer filename to fcb
		mvi		c,openf	;open the file
		lxi		d,filcb
		call	bdos
		cpi		0ffh	;check if file present
		jnz		filprs
		lxi		d,filerr	;print error message and exit if not
		call	prterr
		jmp		txted
filprs	mvi		a,0		;zero current record number in fcb 
		lxi		d,filcb+32
		stax	d
		call	clrbuf	;clear text buffer
		lhld	txtbuf
		shld	curlin
rdrec	mvi		a,3
		sta		tmpchr
		lxi		h,dma
		shld	fillen
		lxi		d,filcb	;read record
		mvi		c,readf
		call	bdos
nxline	lhld	fillen	;process record
		xchg
		ldax	d		;check if eof character present
		cpi		01ah
		jnz		cont41
		mvi		c,closef	;close file if it is
		lxi		d,filcb
		call	bdos
		mvi		a,0		;set cursor coordinates to first line
		sta		curx
		mvi		a,1
		sta		cury
		lhld	txtbuf	;set line address pointer to start of buffer
		shld	linloc	
		lhld	curlin	;set eof address pointer to end of file
		shld	eofptr
		lhld	txtbuf	;display first page of file
		xchg
		call	refrsh
		jmp		txted
cont41	lhld	curlin	;save text line to buffer
		push	h
		pop		b
		lhld	fillen
		xchg
		call	coplin
		lhld	fillen
		lxi		d,42
		dad		d
		shld	fillen
		lhld	curlin
		dad		d
		shld	curlin
		lda		tmpchr
		dcr		a
		sta		tmpchr
		jnz		nxline	;read 3 lines per file record
		jmp		rdrec
notget	cpi		155		;store key?
		jnz		notstr
		mvi		a,0		;clear the status line help flag
		sta		hlpflg
		call	wrtlin	;save line to text buffer
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previously saved line
		dad		d		;update line address 
		shld	linloc
qsave	lhld	linloc	;display save file prompt
		call 	updlin
		call	displn
		lhld	stspos
		inx		h
		push	h
		pop		b
		lxi		d,svtext
		lxi		h,10
		call	VMBW
		call	inpfil	;get filename input from user
		lda		tmpchr	;check flag
		cpi		0
		jz		opcan	;cancel save if flag reset
		call	setfil	;transfer filename to fcb
		mvi		c,delf	;delete filename in directory if exists
		lxi		d,filcb
		call	bdos	
		mvi		c,makef	;create new file
		lxi		d,filcb
		call	bdos
		mvi		a,0		;zero current record number in fcb 
		lxi		d,filcb+32
		stax	d
		lhld	txtbuf	;start of text buffer
		shld	curlin
nxtrec	call	clrdma	;clear the dma
		lhld	curlin
		xchg			;move line address to DE registers
		mvi		a,3		;fill dma with 3 lines
		sta		tmpchr
		lxi		h,dma	;target location in dma
		shld	fillen
		push	h
		pop		b
filnxt	call	coplin	;copy line to dma
		lhld	curlin	;check if at end of file
		lxi		d,42
		dad		d
		shld	curlin
		xchg
		lhld	eofptr
		mov		a,h
		cmp		d
		jnz		cont40
		mov		a,l
		cmp		e
		jnz		cont40
		lda		tmpchr	;check if dma is full
		cpi		1
		jnz		middma
		call	wrtfil	;write record if it is
		cpi		1		;exit if disk is full
		jz      endwrt
		call	clrdma	;set up a new record
		lxi		d,dma	;write eof character to new record
		mvi		a,1ah
		stax	d
		call 	wrtfil
		jmp 	endwrt
middma	mvi		a,1ah	;write eof character to record
		lhld	fillen
		lxi		d,42
		dad		d
		xchg
		stax	d
		call	wrtfil	;write the record and exit
		jmp		endwrt
cont40 	lhld	fillen	;not eof. Keep filling dma
		lxi		d,42
		dad		d
		shld	fillen
		push	h
		pop		b
		lhld	curlin
		xchg
		lda		tmpchr
		dcr		a
		sta		tmpchr
		jnz		filnxt	
wrtrec	call	wrtfil	;3 lines in dma so write record
		cpi		1		;check if disk is full
		jz		endwrt
		jmp		nxtrec
endwrt	mvi		c,closef	;close file
		lxi		d,filcb
		call	bdos
opcan	lda		savflg	;check if save flag is set
		cpi		1
		jz		exit	;exit program after save if set
		jmp		txted
notstr	cpi		2		;control-B?
		jnz		chrkey
		mvi		a,0		;home cursor x position
		sta		curx
		jmp		txted
chrkey	lhld	curpos	;get cursor screen address
		mov		d,a		;place in register D
		call	VSBW	;write character to screen
		lda		curx	;get cursor x position
		inr		a		;increment by 1
		cpi		28h		;beyond end of line?
		jnz		noteol	;if not then move cursor 1 right
		call	beep
		jmp		txted	;return without moving cursor
noteol	sta		curx	;update cursor x position
		jmp		txted
		
;return to CP/M
exit	call	0da66h
		jmp		0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;SUBROUTINES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;clear text buffer + 4 extra lines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
clrbuf	lhld	txtbuf		;point to text buffer
		xchg				;move to DE
		lhld	bufsiz		;size of text buffer in HL + 4 lines
		lxi		b,168
		dad		b
cont6	mvi		a,20h		;space in accumulator
		stax	d			;write a space in buffer location
		inx		d			;next buffer location
		dcx		h			;at end of buffer?
		mov		a,h			
		cpi		0
		jnz		cont6
		mov		a,l
		cpi		0
		jnz		cont6		;keep writing space sequentially if not
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;clear text screen routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
clrscr	lxi		d,03c0h	;SIT is 960 bytes long in text mode
		mvi		a,0		;LSB of SIT address
		out 	0bfh
		mvi		a,48h	;MSB of SIT address
						;second most significant bit made 1
		out 	0bfh
redo	mvi		a,20h	;fill SIT with space
		out 	0beh
		dcx		d		;continue until all locations filled
		mov		a,d
		cpi		0
		jnz		redo
		mov		a,e
		cpi		0
		jnz		redo
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;wait for keypress
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
keyprs	mvi		c,consts
		call	bdos
		ora		a			;check if key pressed
		jz		keyprs		;keep checking if not
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;beep sound
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
beep	mvi		c,conio	
		mvi		e,7
		call	bdos
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;delay routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
delay	lxi		b,1000h
loop	dcx		b
		mov		a,b
		cpi		0
		jnz		loop
		mov		a,c
		cpi		0
		jnz		loop
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;display flashing cursor routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
discur	lhld	curpos	;load current cursor location
		call	VSBR	;read character at cursor location
		sta		tmpchr	;save character
		lhld	curpos
		lda		curchr	;get cursor character
		mov		d,a
		call	VSBW	;display cursor
		call 	delay
		lhld	curpos
		mvi		d,20h	;erase cursor
		call 	VSBW
		lhld	curpos
		lda		tmpchr	;retrieve stored character
		mov		d,a		;place in register D
		call	VSBW	;restore character on screen
		call 	delay
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;calculate the screen address of the cursor
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
clccur	lxi		h,7d8h	;SIT address - 40
		lxi		b,28h	;length of screen line
		lda		cury	;retrieve cursor y position
		mov		d,a		;move to D register
addy	dad		b		;add 28h to HL
		dcr		d		;are we at cursor y?
		jnz		addy	;if not keep adding 28h to HL
		lda		curx	;retrieve cursor x position
		mvi		d,0		;place in DE register pair
		mov		e,a
		dad		d		;add x to HL. Now it has screen address
		shld	curpos	;update cursor position variable
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;save current line to text buffer in memory
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wrtlin	lda		curx	;save current cursor position
		sta		tmpchr
		mvi		a,0		;zero cursor x position
		sta		curx
		call	clccur	;get current screen address of line
		push	h		;move to BC
		pop		b
		lhld	linloc	;get current line location in text buffer
		xchg			;move line location in buffer to DE
		lxi		h,28h	;length of line
		call	VMBR	;save line to buffer
		lhld	linloc	;get current line location in text buffer
		lxi		d,28h	;point to end of line
		dad		d
		shld	linloc	;save back location
		xchg			;move to DE
		mvi		a,0dh	;write CR to end of line
		stax	d		
		xchg			;put back location in HL
		inx		h		;next position in buffer
		shld	linloc	;save back location
		xchg			;move to d
		mvi		a,0ah	;write LF to end of line
		stax	d
		xchg			;put back location in HL
		inx		h		;point to next buffer location
		shld	linloc	;save location of next line
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;check if at end of text buffer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
bufchk	lhld	linloc	;get current line address in buffer
		push	h
		lhld	bufsiz	;calculate end of buffer address
		xchg
		lhld	txtbuf	
		dad		d		;HL now has end address of buffer
		pop		d
		mov		a,h		;check if equal to end of buffer
		cmp		d
		jnz		notend
		mov		a,l
		cmp		e
		jnz		notend
		mvi		a,1		;set accumulator if it is
		ret
notend	mvi		a,0		;reset accumulator if not
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;check if at start of buffer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
bufst	lhld	linloc	;get current line address in buffer
		xchg			;place in DE
		lhld	txtbuf	;get start of buffer address
		mov		a,h		;check if equal to start of buffer
		cmp		d	
		jnz		notst
		mov		a,l
		cmp		e
		jnz		notst
		mvi		a,1		;set accumulator if it is
		ret
notst	mvi		a,0		;reset accumulator if not
		ret
										
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;scroll screen up 5 lines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scrup	lhld	linloc	;get current line location in buffer
		lxi		b,-756	;offset to line location (19 lines)
		dad		b		;HL now has top of screen buffer location
		xchg			;move to DE
		call	refrsh	;refresh the screen
		lda		cury	;get cursor y 
		sui		4		;adjust back 4 lines
		sta		cury	;save back
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;scroll screen down 5 lines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scrdn	lhld	linloc	;get the current line address
		lxi		d,-210	;offset for 5 lines back
		dad		d		;update pointer to buffer
		xchg			;move to DE
		call	refrsh 	;refresh the screen
		lda		cury	;get cursor y
		adi		4		;adjust forward 4 lines
		sta		cury	;save back
		lhld	linloc	;get current line address
		lxi		d,-42	;offset to previous line in buffer
		dad		d		;update pointer
		shld	linloc	 
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;refresh screen
;DE register pair has pointer to current line in text buffer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
refrsh	push	d		;save DE
		lxi		b,800h	;top of screen VRAM address
		lxi		h,28h	;number of characters in line
		mvi		a,23	;counter for number of lines to display
		sta		tmpchr	;save counter
cont5   call	VMBW	;write line to screen from buffer
		lda		tmpchr	;retrieve counter
		dcr		a		;decrement by 1
		jz		done	;if zero then screen refresh is done
		sta		tmpchr	;save back counter
		pop		d		;retrieve current buffer location
		xchg			;move buffer current address to HL
		lxi		d,42	;offset to next line in buffer
		dad		d		;point to next line
		xchg			;put back in DE
		push	d		;save DE
		push	b		;point to next line screen address in VRAM
		pop		h
		lxi		b,28h	;offset to next line screen address
		dad		b
		push	h
		pop		b		;BC is now pointing to next line in VRAM
		lxi		h,28h	;number of characters to write
		jmp		cont5	;write next line
done	pop		d		;remove unused DE value from stack
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;update end of file pointer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
chkeof	lhld	linloc	;get current line address
		xchg			;move to DE
		lhld	eofptr	;get current eof pointer
		mvi		a,0		;reset accumulator
		mov		a,h		;check if line pointer at eof pointer
		cmp		d		
		jnz		noteof	
		mov		a,l
		cmp		e
		jnz		noteof
		mvi		a,1		;set accumulator if it is
noteof	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;copy line from text buffer to another buffer
;address of line to copy in buffer in DE register pair
;address of line buffer in BC register pair
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
coplin	mvi		h,42	;line length
cpchar	ldax	d		;get character from text buffer
		stax	b		;copy to line buffer
		inx		d		;next location 
		inx		b
		dcr		h		;are we done?
		jnz		cpchar	;copy next character if not
		ret	
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;set up filename in file control block
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
setfil	mvi		b,12	;clear filename in fcb
		mvi		a,20h
		lxi		d,filcb
cont33	stax	d
		inx		d
		dcr		b
		jnz   	cont33
		call	extdrv	;extract the drive number
		cpi		0
		jz		noext
		mvi		b,8
		lxi		h,filnam+2	;jump over drive letter and colon
		lxi		d,filcb+1
cont31	mov		a,m		;write filename into fcb
		cpi		8eh		;process extension if present
		jz		igdot
		cpi		0c1h	;check if lower case letter
		jm		notlc
		sui		80h		;convert to upper case
		jmp		cont34
notlc	sui		60h
cont34	stax	d
		inx		d
		inx		h
		dcr		b
		jnz		cont31
		mov		a,m		;look for extension
		cpi		8eh		;dot present?
		jnz		noext	;done if not
igdot	mvi		b,3		;write extension into fcb
		lxi		d,filcb+9
		inx		h
cont32	mov		a,m
		cpi		0c1h	;check if lower case letter
		jm		notlc1
		sui		80h		;convert to upper case
		jmp		cont35
notlc1	sui		60h
cont35	stax	d
		inx		d
		inx		h
		dcr		b
		jnz		cont32
noext	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;extract the drive number from the filename
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
extdrv	lxi		d,filcb
		lda		filnam	;load drive letter
		cpi		0a1h	;A?
		jz		drv1
		cpi		0c1h	;a?
		jz		drv1
		cpi		0a2h	;B?
		jz		drv2
		cpi		0c2h	;b?
		jz		drv2
		cpi		0a3h	;C?
		jz		drv3
		cpi		0c3h	;c?
		jz		drv3
		cpi		0a4h	;D?
		jz		drv4
		cpi		0c4h	;d?
		jz		drv4
		cpi		0a5h	;E?
		jz		drv5
		cpi		0c5h	;e?
		jz		drv5
		cpi		0a6h	;F?
		jz		drv6
		cpi		0c6h	;f
		jz		drv6
drv1	mvi		a,1
		jmp		setdrv
drv2	mvi		a,2
		jmp		setdrv
drv3	mvi		a,3
		jmp		setdrv
drv4	mvi		a,4
		jmp		setdrv
drv5	mvi		a,5
		jmp		setdrv
drv6	mvi		a,6
setdrv	stax	d
		ret
							
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;partial screen refresh
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
prtref	lda		cury	;get current cursor y
		cpi		1		;check if at top of page already
		jnz		cont15
		lhld	linloc
		jmp		donset
cont15	dcr		a		;difference from top of screen
		lhld	linloc	;get buffer address of top line
		lxi		d,-42	
loop2	dad		d
		dcr		a		;are we at top of page yet?
		jnz		loop2	
donset	xchg			;DE now has top line address
		call	refrsh	;refresh the screen
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;check if insert operation is done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
finins	lhld	fillen	;get file length counter
		lxi		d,-42	;decrement by 1 line
		dad		d
		mov		a,h		;check if counter is 0
		cpi		0
		jnz		conins
		mov		a,l
		cpi		0
		jnz		conins
		mvi		a,1
		ret
conins	mvi		a,0		;reset flag if it is not
		shld	fillen	;update counter
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;convert 16 bit binary number to decimal ascii <=9999
;HL has number to convert
;asciin	has converted 4 digit string
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
bindec	lxi		b,asciin
		dcx		b
		lxi		d,-1000	;calculate 1000's
		call	subcnt
		lxi		d,-100	;calculate 100's
		call 	subcnt
		lxi		d,-10	;calculate 10's
		call	subcnt
		lxi		d,-1	;calculate 1's
		call	subcnt
		ret
subcnt	mvi		a,8fh	;ascii of reverse 0 minus 1
sub2	inr		a
		shld	curlin
		dad		d
		jc		sub2	;recurrent subtraction until negative
		inx		b
		stax	b
		lhld	curlin	;recover last positive value of HL
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;display current line number on status line
;HL has line number
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
displn	call	bindec	;convert to ascii decimal string
		lxi		d,statln
		lxi		b,0b98h
		lxi		h,36
		call	VMBW
		lxi		d,asciin
		lxi		b,0bbch
		lxi		h,4
		call	VMBW
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;update line number
;HL contains address of current line in buffer (linloc)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
updlin	lxi		b,1		;line counter
		lxi		d,-42	;text buffer line length
cont26	mov		a,h		;are we at start of text buffer?
		cpi		16h
		jnz		cont25
		mov		a,l
		cpi		0
		jz		finupd
cont25	dad		d		;if not decrease by 1 line
		inx		b
		jmp		cont26
finupd	push	b
		pop		h		;HL now has line number
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;create inverse ascii character set
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
revchr	lxi		b,1024	;start of first char in PDT invert area
		lxi		d,chrstr	;point to storage area
		lxi		h,760	;number of bytes to read
		call	VMBR	;save original pdt area
		mvi		c,95	;number of characters to process
		mvi		b,8		;8 bytes per character
		lxi		h,256	;start of area to invert in PDT
cont27	call	VSBR	;get byte into accumulator
		shld	curlin	;save pointer
		cma				;complement byte
		lxi		d,768	;offset to inverse char set in PDT
		dad		d
		mov		d,a
		call	VSBW	;write byte
		lhld	curlin	;point to next byte to process
		inx		h
		dcr		b		;repeat 8 times
		jnz		cont27
		dcr		c		;go through all the characters
		jz		dntran
		mvi		b,8
		jmp		cont27
dntran	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;enter filename
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
inpfil	lhld	curpos	;save current cursor position
		push	h
		lhld	stspos	;point to VRAM cursor position on status line
		lxi		d,12
		dad		d
		shld	curpos
		push	h		;display previous file name
		pop		b
		lxi		d,filnam
		lxi		h,14
		call	VMBW
		mvi		a,1		;initialize cursor x position
		sta		fcurx
getchr	mvi		a,cursr2	;get inverse cursor character
		sta		curchr
		call	discur
		mvi		c,conio	;look for keypress
		mvi		e,0ffh	;configure function for input
		call	bdos
		ora		a		;is key pressed?
		jnz		cont30	;check key value if it is
		jmp		getchr	;check again if not
cont30	cpi		27		;escape?
		jz		caninp	;cancel input if it is
		cpi		8		;backspace?
		jnz		notrub
		lda		fcurx	;check if already at start of input field
		cpi		1
		jz		getchr	;ignore if it is
		dcr		a		;rubout last character
		sta		fcurx
		lhld	curpos
		dcx		h
		shld	curpos
		mvi		d,80h
		call	VSBW
		jmp		getchr
notrub	cpi		13		;carriage return?
		jnz		entchr
		lhld	stspos	;store filename
		lxi		b,12
		dad		b
		push	h
		pop		b
		lxi		d,filnam
		lxi		h,14 
		call	VMBR
		mvi		a,1		;set flag
		sta		tmpchr
		jmp		inpok
entchr	sta		tmpchr	;save character typed
		lda		fcurx	;at end of input field?
		cpi		15
		jnz		rmleft
		call	beep
		jmp		getchr
rmleft	lda		tmpchr	;retrieve character
		adi		60h		;offset character to inverse set
		mov		d,a		;display character
		lhld	curpos
		call	VSBW	
		lda		fcurx	;increment cursor x
		inr		a
		sta		fcurx
		lhld	curpos
		inx		h
		shld	curpos
		jmp		getchr
caninp	mvi		a,0		;reset flag
		sta		tmpchr
inpok	lhld	linloc
		call 	updlin
		call	displn
		pop		h		;restore current cursor position
		shld	curpos
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;input search string
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
inpsrh	lhld	curpos	;save current cursor position
		push	h
		lhld	stspos	;point to VRAM cursor position on status line
		lxi		d,13
		dad		d
		shld	curpos
		push	h		;display previous search string
		pop		b
		lxi		d,srhstr
		lxi		h,15
		call	VMBW
		mvi		a,1		;initialize cursor x position
		sta		fcurx
getch1	mvi		a,cursr2	;get inverse cursor character
		sta		curchr
		call	discur
		mvi		c,conio	;look for keypress
		mvi		e,0ffh	;configure function for input
		call	bdos
		ora		a		;is key pressed?
		jnz		cont50	;check key value if it is
		jmp		getch1	;check again if not
cont50	cpi		32		;space?
		jnz		cont51	
		lda		fcurx	;if at beginning of field then ignore
		cpi		1
		jz		getch1
		mvi		a,32
		jmp		entch1 
cont51	cpi		27		;escape?
		jz		cncinp	;cancel input if it is
		cpi		8		;backspace?
		jnz		notbks
		lda		fcurx	;check if already at start of input field
		cpi		1
		jz		getch1	;ignore if it is
		dcr		a		;rubout last character
		sta		fcurx
		lhld	curpos
		dcx		h
		shld	curpos
		mvi		d,80h
		call	VSBW
		jmp		getch1
notbks	cpi		13		;carriage return?
		jnz		entch1
		lhld	stspos	;store search string
		lxi		b,13
		dad		b
		push	h
		pop		b
		lxi		d,srhstr
		lxi		h,15 
		call	VMBR
		mvi		a,1		;set flag
		sta		tmpchr
		jmp		inppok
entch1	sta		tmpchr	;save character typed
		lda		fcurx	;at end of input field?
		cpi		16
		jnz		spcleft
		call	beep
		jmp		getch1
spcleft	lda		tmpchr	;retrieve character
		adi		60h		;offset character to inverse set
		mov		d,a		;display character
		lhld	curpos
		call	VSBW	
		lda		fcurx	;increment cursor x
		inr		a
		sta		fcurx
		lhld	curpos
		inx		h
		shld	curpos
		jmp		getch1
cncinp	mvi		a,0		;reset flag
		sta		tmpchr
inppok	lhld	linloc
		call 	updlin
		call	displn
		pop		h		;restore current cursor position
		shld	curpos
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print error message
;address of message in DE register (15 characters long)
;ascii code of key pressed returned in tmpchr
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
prterr	lhld	stspos
		inx		h
		push	h
		pop		b
		lxi		h,15
		call	VMBW
		call	beep
wait	mvi		c,conio	;look for keypress
		mvi		e,0ffh	;configure function for input
		call	bdos
		ora		a		;is key pressed?
		jz		wait
		sta		tmpchr
		lhld	linloc	;restore status line
		call	updlin
		call	displn
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;write record to file
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wrtfil	mvi		c,writef
		lxi		d,filcb
		call	bdos
		cpi		0
		jnz		wrterr
		mvi		a,0
		ret
wrterr	lxi		d,direrr
		call	prterr
		mvi		a,1
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;clear the dma
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
clrdma	mvi		a,3		
		lxi		d,dmablk
		lxi		b,dma
		push	b
nxtfld	sta		tmpchr
		call	coplin
		pop		h
		lxi		d,42
		dad		d
		push	h
		pop		b
		push	b
		lxi		d,dmablk
		lda		tmpchr
		dcr		a
		jnz		nxtfld
		pop		b
		mvi		a,0dh
		lxi		d,dma+126 ;fill the last 2 dma positions with CR
		stax	d
		inx		d
		stax	d
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;insert a line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
inslin	lhld	eofptr	;check if text buffer full
		xchg
		lhld	bufsiz
		push	h
		pop		b
		lhld	txtbuf
		dad		b		;HL now pointing to end of buffer
		mov		a,d
		cmp		h
		jnz		notful
		mov		a,e
		cmp		l
		jnz		notful
		jmp		txted	;ignore if buffer is full
notful	lhld	txtbuf	;calculate length of file
		xchg
		lhld	eofptr
		mov		a,l
		sub		e
		mov		l,a
		mov		a,h
		sbb		d
		mov		h,a
		shld	fillen	;save file length in counter
		lhld	eofptr	;increase eof pointer by 1 line
		lxi		d,42
		dad		d
		shld	eofptr
		lhld	linloc	;save current line pointer
		shld	curlin
		lxi		d,42	;copy 2nd line to buffer
		dad		d
		xchg	
		lxi		b,linbuf
		call	coplin	
		lhld	curlin	;move 1st line to 2nd
		xchg
		lhld	curlin
		lxi		b,42
		dad		b
		push	h
		pop		b
		call	coplin
		lxi		h,blklin	;blank current line in buffer
		xchg
		lhld	linloc
		push	h
		pop		b
		call	coplin
		call	finins	;check if insert operation done
		cpi		1
		jz		finop
loop1	lhld	curlin	;copy 3rd line to buffer
		lxi		d,84
		dad		d	
		xchg
		lxi		b,lnbuf1
		call	coplin
		lxi		d,linbuf	;move 2nd line to 3rd
		lhld	curlin
		lxi		b,84
		dad		b
		push	h
		pop		b
		call	coplin
		call	finins	;check if insert operation done
		cpi		1
		jz		finop
		lhld	curlin	;copy 4th line to buffer
		lxi		d,126
		dad		d
		xchg
		lxi		b,linbuf
		call	coplin
		lxi		d,lnbuf1	;move 3rd line to 4th
		lhld	curlin
		lxi		b,126
		dad		b
		push	h
		pop		b
		call 	coplin
		call	finins	;check if insert operation done
		cpi		1
		jz		finop
		lhld	curlin	;update current line pointer
		lxi		d,84
		dad		d
		shld	curlin
		jmp		loop1	
finop	call	prtref	;refresh the screen
		jmp		txted
					
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
;read VRAM - multiple bytes
;start of VRAM address in register pair BC
;number of bytes to read in register pair HL
;start of data buffer in register pair DE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VMBR	mov 	a,c		;LSB of VRAM address
		out		0bfh
		mov		a,b		;MSB of VRAM address
		ani		3fh		;zero 2 most significant bits
		out 	0bfh
redo1	in		0beh	;read byte into accumulator
		stax	d		;store into buffer
		inx		d		;next buffer location
		dcx		h		;are we done reading?
		mov		a,h
		cpi		0
		jnz		redo1
		mov		a,l
		cpi		0
		jnz		redo1	;if not read next byte
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;read VRAM - single byte
;address of VRAM in register pair HL
;byte read will be in accumulator
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VSBR	mov 	a,l		;LSB of VRAM address
		out		0bfh
		mov		a,h		;MSB of VRAM address
		ani		3fh		;zero 2 most significant bits
		out 	0bfh
		in		0beh	;read byte into accumulator
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
;write to VRAM - multiple bytes
;start VRAM address in register pair BC
;number of bytes to write in register pair HL
;start of data buffer in register pair DE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VMBW	mov		a,c		;LSB of VRAM address
		out 	0bfh
		mov		a,b		;MSB of VRAM address
		ani		7fh		;Make most significant bit 0
		ori		40h		;Make second most significant bit 1
		out 	0bfh
nxtbyt	ldax	d		;load byte from data buffer
		out 	0beh	;write byte to VRAM
		inx		d		;next buffer location
		dcx		h		;are we at end of buffer?
		mov		a,h
		cpi		0
		jnz		nxtbyt
		mov		a,l
		cpi		0
		jnz		nxtbyt	;load next byte if not
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;write to VRAM - single byte
;address of VRAM in register pair HL
;byte to write in register D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VSBW	mov		a,l		;LSB of VRAM address
		out 	0bfh
		mov		a,h		;MSB of VRAM address
		ani		7fh		;Make most significant bit 0
		ori		40h		;Make second most significant bit 1
		out 	0bfh
		mov		a,d		;load byte
		out		0beh	;write byte to VRAM
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;restore CP/M VDP state (standard bitmap mode)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
rescpm	call	0da66h
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
tmpchr	ds	1		;temporary character storage
srhcur	ds	1		;search string cursor
curchr	ds	1		;cursor character
fcurx	ds	1		;filename cursor x
tabpos	ds	2		;tab setting
asciin	ds	4		;ascii 16 bit number
filnam	ds	14		;filename
srhstr	ds	15		;search string
linbuf	ds	42		;line buffer
lnbuf1	ds	42		;line buffer
copbuf	ds	42		;copy buffer
chrstr	ds	760		;storage for ascii table

curpos	dw	0		;cursor screen address in VRAM
stspos	dw	0b98h	;screen address of status line in VRAM
linloc	dw	1600h	;location of current line in text buffer
txtbuf	dw	1600h	;start of text buffer
eofptr	dw	1600h	;pointer to end of file
bufsiz	dw	0a800h	;size of text buffer 
curlin	dw	0		;temporary pointer
fillen	dw	0		;file length counter
srhptr	dw	0		;search line pointer

curx	db	0		;cursor x position on line (0-39)
cury	db	1		;cursor y position on screen (1-23)
tabasm	db	7,12,19,23,30,0	;tab positions for assembly
tabpas	db	2,5,8,11,14,17,20,23,26,29,0 ;tab positions for pascal
hlpflg	db	0		;help flag
savflg	db	0		;save flag

title1	db	80h,0a1h,0a4h,0a1h,0adh,0a5h,0a4h,80h
title2	db	80h,0a6h,0afh,0b2h,0b4h,0b9h,80h,0a3h,0afh,0ach,0b5h,0adh
		db	0aeh,80h,0b4h,0a5h,0b8h,0b4h,80h,0a5h,0a4h,0a9h,0b4h
		db	0afh,0b2h,80h
credit	db	'BY WALID MAALOULI'
date	db	'JULY 2019'
ststxt	db	0a9h,9ah,0b4h,0afh,0a6h,80h,0a9h,0a9h,9ah,0a5h,0afh,0a6h
		db	80h,0a9h,0a9h,0a9h,9ah,0b0h,0c7h,0b5h,80h,0a9h,0b6h,9ah
		db	0b0h,0c7h,0a4h,80h,0b6h,9ah,0a4h,0ach,0ceh,80h,0b6h,0a9h
		db	9ah,0b3h,0b2h,0a8h
blklin	db	'                                        ',0dh,0ah
dmablk	db 	'                                           '
statln	db	80h,80h,80h,80h,80h,80h,80h,80h,80h,80h
		db	80h,80h,80h,80h,80h,80h,80h,80h,80h,80h
		db	80h,80h,80h,80h,80h,80h,80h,80h,80h,80h
		db	80h,0ach,0c9h,0ceh,0c5h,9ah
ldtext	db	0ach,0afh,0a1h,0a4h,80h,0a6h,0a9h,0ach,0a5h,09ah
svtext	db	0b3h,0a1h,0b6h,0a5h,80h,0a6h,0a9h,0ach,0a5h,09ah
direrr	db	0a4h,0a9h,0b3h,0abh,80h,0a6h,0b5h,0ach,0ach,81h,80h,80h,80h,80h,80h
filerr	db	0a6h,0a9h,0ach,0a5h,80h,0aeh,0afh,0b4h,80h,0a6h,0afh,0b5h,0aeh,0a4h,81h
extprt	db	0b1h,0b5h,0a9h,0b4h,80h,0a5h,0a4h,0a9h,0b4h,0afh,0b2h,9fh,80h,80h,80h
savprt	db	0b3h,0a1h,0b6h,0a5h,80h,0a6h,0a9h,0ach,0a5h,9fh,80h,80h,80h,80h,80h
srhtxt	db	0b3h,0a5h,0a1h,0b2h,0a3h,0a8h,80h,0a6h,0afh,0b2h,09ah
srhfl	db	0aeh,0afh,80h,0adh,0a1h,0b4h,0a3h,0a8h,081h,80h,80h,80h,80h,80h,80h
svflnm	db	'ADAMED  CFG'
	
		end